#include "afxwin.h"

/*
Example of ss.dll source file
The ss.dll (x86 version only) is called from ss.exe.
Set breakpoints to the functions you want analyze:
Breakpoints should be set before starting debugging.
If this function from default list of DLL go to Option menu and select
"Default Breakpoint List Config".
If the function from other DLL, load the DLL first (Option menu - "Add DLL"), then
Option menu - "Default Breakpoint List Config".
The name of export function FillBreakPointParamsExternal and parameters cannot be changed!
Parameters:
HANDLE handle - debuggee handle
const char * strFuncName - exact name of the function with breakpoint
DWORD dwRetAddress - return address (always 0 for demo version);
DWORD * dwParams - array, size of array = 10, 
dwParam[0] - dwParam[9] - parameter values, from left to right
FARPROC SetRetBreakPoint - pointer to function to set breakpoint to return address (the function is located in ss.exe)
PVOID InternalParam - internal param to SetRetBreakPoint

return value LPCTSTR - buffer of debug output text for current breakpoint
*/

// template of 
//CString FillBreakPointParamsExternal(HANDLE, ProcItem *, DWORD, DWORD , DWORD);

//SetBreakpointOnRetAddress function in ss.exe
// Parameters:
//    1. HANDLE - process handle
//    2. PVOID - internal param
//    3. DWORD - parameter from dwParams arrays (for example it may be a pointer which receives data), 0 if not used 
//    4. DWORD - parameter from dwParams arrays (for example it may be a pointer which receives data), 0 if not used  
//    5  DWORD - parameter from dwParams arrays (for example it may be a pointer which receives data), 0 if not used  
typedef void (WINAPI * PFUNCSETBREAKPOINTONRETADDRESS)(HANDLE, PVOID, DWORD, DWORD , DWORD);
PFUNCSETBREAKPOINTONRETADDRESS g_SetBreakpointOnRetAddress;
void takebufferASCII(HANDLE, char*, DWORD );

__declspec(dllexport) LPCTSTR WINAPI FillBreakPointParamsExternal(HANDLE handleProcess, const char * strFuncName,
                                                        const char * strModuleName, DWORD dwRetAddress, DWORD * dwParams,
                                                        FARPROC SetRetBreakPoint, PVOID InternalParam)
{
   char szBuffer[1024];
   char szBufferTmp[255];

   memset(szBuffer,0,1024);
   
   g_SetBreakpointOnRetAddress = (PFUNCSETBREAKPOINTONRETADDRESS)SetRetBreakPoint;
   if(strcmp(strFuncName,"MessageBoxA")==0)
   {
      //int WINAPI MessageBoxA(
      // __in_opt HWND hWnd,
      // __in_opt LPCSTR lpText,
      // __in_opt LPCSTR lpCaption,
      // __in UINT uType);
      sprintf(szBuffer,"Break point @ %s (Module: %s)\r\n",strFuncName, strModuleName);
      // return address
      if(dwRetAddress!=0)
         sprintf(szBufferTmp, "Return address: %08X\r\n",dwRetAddress);
      else
         strcpy(szBufferTmp,"Return address: ????????\r\n");
      strcat(szBuffer,szBufferTmp);
      // Parameter 1
      sprintf(szBufferTmp, "Param 1 (HWND): %08X\r\n",dwParams[0]);
      strcat(szBuffer,szBufferTmp);

      // Parameter 2
      strcat(szBuffer,"Param 2 (MessageBox Text): ");
      takebufferASCII(handleProcess, szBuffer, dwParams[1] );

      // Parameter 2
      strcat(szBuffer,"Param 3 (MessageBox Caption): ");
      takebufferASCII(handleProcess, szBuffer, dwParams[2] );


      // Parameter 4
      sprintf(szBufferTmp, "Param 4 (uType): %08X\r\n",dwParams[3]);
      strcat(szBuffer,szBufferTmp);

      g_SetBreakpointOnRetAddress(handleProcess, InternalParam, 0, 0, 0);
   }
// add other functions to process
//   if(strcmp(strFuncName,"MessageBoxW")==0)
//   {
//     ......
//   }
   return (LPCTSTR)szBuffer;
}

__declspec(dllexport) LPCTSTR FillRetAddrBreakPointParamsExternal(HANDLE handleProcess, const char * strFuncName,
                                                        const char * strModuleName, DWORD regEAX,
                                                        DWORD dwParam1, DWORD dwParam2, DWORD dwParam3)
{
   char szBuffer[1024];
   char szBufferTmp[255];

   memset(szBuffer,0,1024);
   
   if(strcmp(strFuncName,"MessageBoxA")==0)
   {
      strcpy(szBuffer, "Break point after MessageBoxA\r\n");
      sprintf(szBufferTmp, "Return value: %08X\r\n",regEAX);
      strcat(szBuffer,szBufferTmp);
   }  
   return (LPCTSTR)szBuffer;
}
// return buffer info in ascii from process memory
void takebufferASCII(HANDLE hProcess, char * szBuffer, DWORD dwAddr )
{
   DWORD dwNumBytes;
   BYTE byBuffer; 
   BOOL bRetWR;
   DWORD dwIndex = 0;
   int nLen = strlen(szBuffer);
   do
   {
      bRetWR = ReadProcessMemory(hProcess, 
         LPVOID(dwAddr+dwIndex), &byBuffer, 1, &dwNumBytes);
      if(bRetWR)
      {
         if(byBuffer)
            szBuffer[nLen+dwIndex] = byBuffer;
      } else {
         szBuffer[nLen+dwIndex] = '?';
      }
      dwIndex++;
   } while((byBuffer) && (bRetWR));
   strcat(szBuffer,"\r\n");
}

