﻿#define _WIN32_WINNT    
using System;
using System.Runtime.InteropServices;
namespace NtQuerySystemInformationCSharp
{
    [StructLayout(LayoutKind.Sequential)]
    internal struct CLIENT_ID
    {
        UInt32 UniqueProcess;
        UInt32 UniqueThread;
    }
    // VM_COUNTER has different definition for 64 and 32 bit platforms
    // see
    // http://www.rohitab.com/discuss/topic/40626-list-processes-using-ntquerysysteminformation/
    [StructLayout(LayoutKind.Sequential)]
    internal struct VM_COUNTERS_64
    {
        UIntPtr PeakVirtualSize;
        UIntPtr PageFaultCount;
        UIntPtr PeakWorkingSetSize;
        UIntPtr WorkingSetSize;
        UIntPtr QuotaPeakPagedPoolUsage;
        UIntPtr QuotaPagedPoolUsage;
        UIntPtr QuotaPeakNonPagedPoolUsage;
        UIntPtr QuotaNonPagedPoolUsage;
        UIntPtr PagefileUsage;
        UIntPtr PeakPagefileUsage;
        UIntPtr VirtualSize;
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct VM_COUNTERS
    {
        UIntPtr PeakVirtualSize;
        UIntPtr VirtualSize;
        UInt32 PageFaultCount;
        UIntPtr PeakWorkingSetSize;
        UIntPtr WorkingSetSize;
        UIntPtr QuotaPeakPagedPoolUsage;
        UIntPtr QuotaPagedPoolUsage;
        UIntPtr QuotaPeakNonPagedPoolUsage;
        UIntPtr QuotaNonPagedPoolUsage;
        UIntPtr PagefileUsage;
        UIntPtr PeakPagefileUsage;
    }

    [StructLayout(LayoutKind.Sequential)]
    internal struct SYSTEM_THREADS
    { 
        public Int64      KernelTime;
        Int64      UserTime;
        Int64      CreateTime;
        UIntPtr    WaitTime;
        UIntPtr    StartAddress;
        CLIENT_ID  ClientId;
        IntPtr     Priority;
        IntPtr     BasePriority;
        UIntPtr    ContextSwitchCount;
        IntPtr     State;
        IntPtr     WaitReason;
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct IO_COUNTERS {
        public Int64 ReadOperationCount;
        public Int64 WriteOperationCount;
        public Int64 OtherOperationCount;
        public Int64 ReadTransferCount;
        public Int64 WriteTransferCount;
        public Int64 OtherTransferCount;
    } 
    [StructLayout(LayoutKind.Sequential)]
    internal struct UNICODE_STRING
    {
	    Int16     Length;
	    Int16     MaximumLength;
	    public IntPtr    Buffer;
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct RESERVED1
    {
        UInt32 Reserved1_0;
        UInt32 Reserved1_1;
        UInt32 Reserved1_2;
        UInt32 Reserved1_3;
        UInt32 Reserved1_4;
        UInt32 Reserved1_5;
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct RESERVED2
    {
        UInt32 Reserved2_0;
        UInt32 Reserved2_1;
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct SYSTEM_PROCESSES
    {
        public UInt32 NextEntryDelta;
        public UInt32 ThreadCount;
        public RESERVED1 Reserved1;
        public Int64 CreateTime;
        public Int64 UserTime;
        public Int64 KernelTime;
        public UNICODE_STRING ProcessName;
        public IntPtr BasePriority;
        public IntPtr ProcessId;
        public UIntPtr InheritedFromProcessId;
        public UIntPtr HandleCount;
        public RESERVED2 Reserved2;
        public VM_COUNTERS VmCounters;
#if _WIN32_WINNT
        public IO_COUNTERS IoCounters;
#endif
        SYSTEM_THREADS Threads;  // take the first thread
    }
    [StructLayout(LayoutKind.Sequential)]
    internal struct SYSTEM_PROCESSES_64
    {
        public UInt32 NextEntryDelta;
        public UInt32 ThreadCount;
        public RESERVED1 Reserved1;
        public Int64 CreateTime;
        public Int64 UserTime;
        public Int64 KernelTime;
        public UNICODE_STRING ProcessName;
        public IntPtr BasePriority;
        public IntPtr ProcessId;
        public UIntPtr InheritedFromProcessId;
        public UIntPtr HandleCount;
        public RESERVED2 Reserved2;
        public VM_COUNTERS_64 VmCounters;
#if _WIN32_WINNT
        public IO_COUNTERS IoCounters;
#endif
        SYSTEM_THREADS Threads;  // take the first thread
    }
    class Program
    {
        const UInt32 SystemProcessInformation = 5;
        const UInt32 STATUS_SUCCESS = 0;
        const UInt32 STATUS_INFO_LENGTH_MISMATCH = 0xC0000004;
        
        [DllImport("ntdll.dll")]
        public static extern UInt32 NtQuerySystemInformation(UInt32 infoClass, IntPtr regInfo, UInt32 size, ref UInt32 retSize);

        static void Main(string[] args)
        {
            int processes = 0;
            IntPtr prcInfo = IntPtr.Zero;
            int size = 102400;
            UInt32 retSize = 0;
            UInt32 retVal = STATUS_SUCCESS;
            do
            {
                prcInfo = Marshal.AllocHGlobal(size);
                retVal = NtQuerySystemInformation(SystemProcessInformation, prcInfo, (UInt32)size, ref retSize);
                if (retVal == STATUS_INFO_LENGTH_MISMATCH)
                {
                    Marshal.FreeHGlobal(prcInfo);
                    size *= 2;
                }
            }
            while ((retVal != STATUS_SUCCESS) && (retVal == STATUS_INFO_LENGTH_MISMATCH));

            if (retVal == STATUS_SUCCESS)
            {
                SYSTEM_PROCESSES sysProcess;
                SYSTEM_PROCESSES_64 sysProcess64;
                IntPtr prcInfoTmp = prcInfo;
                UInt32 dataSize = 0;
                do
                {
                    if (IntPtr.Size == 4)
                    {
                        // 32 bit platform
                        sysProcess = (SYSTEM_PROCESSES)Marshal.PtrToStructure(prcInfoTmp, typeof(SYSTEM_PROCESSES));
                        dataSize = sysProcess.NextEntryDelta;
                        Console.WriteLine("{0}. Process Id: {1} (Parent: {2}), ; process name: {3} \r\n" +
                            "ReadOperationCount: {4}; WriteOperationCount: {5}; OtherOperationCount: {6} \r\n" +
                            "ReadTransferCount: {7}; WriteTransferCount: {8}; OtherTransferCount: {9}\r\n\r\n", processes + 1,
                            sysProcess.ProcessId, sysProcess.InheritedFromProcessId, Marshal.PtrToStringUni(sysProcess.ProcessName.Buffer),
                            sysProcess.IoCounters.ReadOperationCount, sysProcess.IoCounters.WriteOperationCount,
                            sysProcess.IoCounters.OtherOperationCount,
                            sysProcess.IoCounters.ReadTransferCount, sysProcess.IoCounters.WriteTransferCount,
                            sysProcess.IoCounters.OtherTransferCount);
                    }
                    else
                    {
                        // 64 bit platform
                        sysProcess64 = (SYSTEM_PROCESSES_64)Marshal.PtrToStructure(prcInfoTmp, typeof(SYSTEM_PROCESSES_64));
                        dataSize = sysProcess64.NextEntryDelta;
                        Console.WriteLine("{0}. Process Id: {1} (Parent: {2}), ; process name: {3} \r\n" +
                            "ReadOperationCount: {4}; WriteOperationCount: {5}; OtherOperationCount: {6} \r\n" +
                            "ReadTransferCount: {7}; WriteTransferCount: {8}; OtherTransferCount: {9}\r\n\r\n", processes + 1,
                            sysProcess64.ProcessId, sysProcess64.InheritedFromProcessId, Marshal.PtrToStringUni(sysProcess64.ProcessName.Buffer),
                            sysProcess64.IoCounters.ReadOperationCount, sysProcess64.IoCounters.WriteOperationCount,
                            sysProcess64.IoCounters.OtherOperationCount,
                            sysProcess64.IoCounters.ReadTransferCount, sysProcess64.IoCounters.WriteTransferCount,
                            sysProcess64.IoCounters.OtherTransferCount);
                    }


                    prcInfoTmp = new IntPtr(prcInfoTmp.ToInt64() + dataSize);
                    processes++;
                } while (dataSize != 0);
                if (prcInfo != IntPtr.Zero)
                    Marshal.FreeHGlobal(prcInfo);
                string applicationPlatform = (IntPtr.Size == 4) ? "32 bit" : "64 bit";
                Console.WriteLine("Processes (total): {0}. Application in {1} mode.", processes, applicationPlatform);
            }
        }
    }
}
