#include <stdio.h>
#include "irc.h"

CWinThread * cwinthread;
WinHost * pWinHostCommon;
DWORD  dwBegin;
DWORD  dwEnd;
CString  csLocalHost;
CString  csRemoteHost;
//WinSockDLL class implementation
//Constructor (init. Win Socket DLL connection)
WinSockDLL::WinSockDLL()
{
    iResult = 0;
    iResult = WSAStartup(WS_VERSION_REQD,&wsadata);
    if (iResult != 0) {
      printf ("\nWINSOCK.DLL does not responding\n");
    }
    else {
       if((LOBYTE (wsadata.wVersion)<WS_VERSION_MAJOR) ||
           (LOBYTE (wsadata.wVersion)==WS_VERSION_MAJOR) &&
           (HIBYTE (wsadata.wVersion)<WS_VERSION_MINOR))  {
            printf ("\nWindows Sockets version %d.%d is not"
              " supported by WINSOCK.DLL",
              LOBYTE (wsadata.wVersion),
              HIBYTE (wsadata.wVersion));
           iResult = -1;
       }
    }
};
//WinSockDLL class implementation
//Constructor (init. Win Socket DLL connection)
WinHost::WinHost(CString m_host,WinSockDLL * pWinSockDLL)
{
	iResult = 0;
	pWinHostCommon = this;
	//Operation with local host
	if((pWinSockDLL!=0) && (pWinSockDLL->ReturnResult() == 0)) {
	   if(gethostname(szHostLocal,80)!=0) {
	      printf("\nUnable to take Local Host Name\n");
       } else {
	      pHostEntLocal = gethostbyname(szHostLocal);
		  if (pHostEntLocal==0) {
             printf("\nYour Local Host Name was not found\n");
          } else {
             csLocalHost = pHostEntLocal->h_name;
             printf("\nYour Local Host Name:    %s",pHostEntLocal->h_name);
             printf("\nYour Local Host Address: %u.%u.%u.%u\n",
                (int)**pHostEntLocal->h_addr_list & 0xff,
                (int)*(*pHostEntLocal->h_addr_list+1) & 0xff,
                (int)*(*pHostEntLocal->h_addr_list+2) & 0xff,
                (int)*(*pHostEntLocal->h_addr_list+3) & 0xff);
             if ((**pHostEntLocal->h_addr_list==127) &&
                (*(*pHostEntLocal->h_addr_list+1)==0) &&
                (*(*pHostEntLocal->h_addr_list+2)==0) &&
                (*(*pHostEntLocal->h_addr_list+3)==1)) {
                printf("\nYour Local Host Address is 127.0.0.1 - you are not connected\n");
			    iResult = -1;
             }
	      }
	   }	
	}
	//Operation with remote host
	if((pWinSockDLL!=0) && (pWinSockDLL->ReturnResult() == 0) && (iResult != -1)) {
        szHostRemote = m_host.GetBuffer(m_host.GetLength());      
		for(byIndex = 0; byIndex<strlen(szHostRemote); byIndex++) {
           if((szHostRemote[byIndex]!='.') && 
              !((szHostRemote[byIndex]<='9') &&
			  (szHostRemote[byIndex]>='0'))) iResult = 1;
        }
		if(iResult == 1) {
        //Try to Get Host By Name
           iResult = 0;
		   pHostEntRemote = gethostbyname(szHostRemote);
		   if (pHostEntRemote == 0) {
              iResult = -1;
           }
		} else {
           in_addr = inet_addr(szHostRemote);
		   for(byIndex = 0;byIndex<4; byIndex++) {
              cHostAddr[byIndex]=((int)in_addr & 0xff);  //Put every address domain into byte array
              in_addr/=256;
		   }
		   pHostEntRemote = gethostbyaddr(cHostAddr,4,PF_INET); 
           if(pHostEntRemote == 0) {

			    pHostEntRemote = pHostEntLocal;
				pHostEntRemote->h_name[0] = '\0';

				**pHostEntRemote->h_addr_list = cHostAddr[0];
                *(*pHostEntRemote->h_addr_list+1) = cHostAddr[1];  
                *(*pHostEntRemote->h_addr_list+2) = cHostAddr[2];  
                *(*pHostEntRemote->h_addr_list+3) = cHostAddr[3];  
		   }
		}   
        if(pHostEntRemote !=0) {
           csRemoteHost = pHostEntRemote->h_name;
		   printf("\nYour Remote Host Name:    %s",pHostEntRemote->h_name);
           printf("\nYour Remote Host Address: %u.%u.%u.%u\n",
              (int)**pHostEntRemote->h_addr_list & 0xff,
              (int)*(*pHostEntRemote->h_addr_list+1) & 0xff,
              (int)*(*pHostEntRemote->h_addr_list+2) & 0xff,
              (int)*(*pHostEntRemote->h_addr_list+3) & 0xff);
        } else {
 		   printf("\nHost was not found by name\n");       
		}
    }
};
// WinSockDLL class implementation
//Destructor (Close connection with Win Socket DLL)
WinSockDLL::~WinSockDLL()
{
   if (iResult == 0) {
      WSACleanup();
   }
};

//WinSocket class implementation
//Constructor (creat socket)
WinSocket::WinSocket()
{
  iResult = -1;
  if(pWinHostCommon != 0) {
     Socket=INVALID_SOCKET;
     Socket=socket(AF_INET,SOCK_STREAM,0);
     if (Socket!=INVALID_SOCKET) {
        //Member function (Connect socket with the remote Host)
        memset(&Address,0,sizeof(Address));
        memcpy(&(Address.sin_addr),*pWinHostCommon->pHostEntRemote->h_addr_list,pWinHostCommon->pHostEntRemote->h_length);
        Address.sin_family=pWinHostCommon->pHostEntRemote->h_addrtype;
        iPort = IRC_PORT;
		Address.sin_port=htons(iPort);    //irc
        iResult = connect(Socket,(struct sockaddr*) &Address,sizeof(Address));
     } 
  }
  if(iResult != 0) {
     printf("\nSocket was not connected with port %d\n",iPort);
  }
};
WinHost::~WinHost()
{
};

//Destructor (close socket)
WinSocket::~WinSocket()
{
  if (Socket!=INVALID_SOCKET) {
     closesocket(Socket);
  } 
};
int WinSocket::SendSocket (CString cstring) 
{
   iResult = 0;
   if(send(Socket,cstring,cstring.GetLength(),0)!=cstring.GetLength()) {
	  iResult = -1; 
   }
   return(iResult);
};

//WinIRC class implementation
//Constructor (creat socket)
WinIRC::WinIRC(CString m_InitIRC)
{
	CString  csCommand;
	int iIocl;
	unsigned long		argp;

    WORD  wLenth = 0;
	char cBuffer[0xffff];
	wChannelLenth = 0;
	wChatNumber = 0;
	memset(&cBuffer,0,0xffff);

	if((Socket!=INVALID_SOCKET) && (WinSocket::ReturnResult()==0)) {
	   WinSocket::SendSocket(m_InitIRC);
	}
	if((Socket!=INVALID_SOCKET) && (WinSocket::ReturnResult()==0)) {
	   wLenth = recv(Socket,cBuffer,0xffff,0);
	   printf("\nSocket: %d\n%s",(int)Socket,cBuffer);
	   do {
	      iIocl = ioctlsocket(Socket, FIONREAD, &argp);
	      if ((argp) && (wLenth < (0xffff))) {
	         WORD wLenthRead = recv(Socket,&cBuffer[wLenth],0xffff-wLenth,0);
             printf("%s",&cBuffer[wLenth]);
             wLenth += wLenthRead;
	      }
		  csCommand = cBuffer;
          int nPing = csCommand.Find("PING ");
          if(nPing!=-1) {
              csCommand = csCommand.Right(csCommand.GetLength() - nPing -4);
              csCommand.TrimLeft();
              nPing = csCommand.Find('\r');
              if(nPing != -1)  csCommand = csCommand.Left(nPing);
              csCommand = "PONG " + csCommand;
              //csCommand += csLocalHost;
              //csCommand += " ";
              //csCommand += csRemoteHost;
              csCommand += "\r\n";
              WinSocket::SendSocket(csCommand);
              wLenth = 0;
	          memset(&cBuffer,0,0xffff);
              printf("\nPing - Pong\n");
          } 
          if(csCommand.Find("/QUOTE") !=  -1) {
             int iQuote = csCommand.Find("/QUOTE"); 
             csCommand = csCommand.Right(csCommand.GetLength()-iQuote);
             WinSocket::SendSocket(csCommand);
             wLenth = 0;
	         memset(&cBuffer,0,0xffff);
           }
	   } while ((csCommand.Find("MOTD")==-1));
       //printf("\nSocket: %d\n%s",(int)Socket,cBuffer);
	}
	csCommand = cBuffer;
	if((WinSocket::ReturnResult()!=0)  ||
	   (csCommand.Find("ERROR")!=-1) ||
	   (csCommand.Find("431")!=-1) ||
       (csCommand.Find("432")!=-1) ||
       (csCommand.Find("433")!=-1) ||
       (csCommand.Find("436")!=-1)) {
	   printf("\nYou have no access by any reason. Read above!\n"); 
	   bResult = FALSE;
	} else {
	   bResult = TRUE;
    }
};
WinIRC::~WinIRC()
{
    if((Socket!=INVALID_SOCKET) && (WinSocket::ReturnResult()==0)) {
	   WinSocket::SendSocket("QUIT :End of advertising\r\n");
    }
};
