/*((
******************************************************************************
*
*                               IRC.H
*
******************************************************************************

Project:        IRC automatic broadcaster

Description:    WinSockDll, WinHost, WinSocket  
                Class prototypes

Originator:     Alex Ermolaev

Created:        21 July 1997

*/
#include <afxwin.h>
#include <winsock.h>
#include "constants.h"

#ifndef IRC_H
#define IRC_H 

extern BYTE   ReConnect; 
extern DWORD  dwMessages;
extern CString csNick;
extern SOCKET  Socket;

// Declaration of WinSockDLL class
class WinSockDLL
{
   private:
      int iResult;
	  WSADATA  wsadata;
   public:
	  struct hostent * pHostEntRemote;
      WinSockDLL();   //function initiates use of the Windows Sockets DLL by a process.
	  ~WinSockDLL();
	  ReturnResult(void){return iResult;};
};
//Declaration of WinHost class
class WinHost
{
   private:
      int iResult;
  	  BYTE   byIndex;
  	  char * szHostRemote;
	  char   szHostLocal[80];
  	  struct hostent * pHostEntLocal;
  	  unsigned long  in_addr;
	  char   cHostAddr[4];  
   public:
   	  struct hostent * pHostEntRemote;
	  WinHost(CString m_host,WinSockDLL * pWinSockDLL);
	  ~WinHost();
	  int ReturnResult(void){return iResult;}
};
//Declaration of WinSocket class
class WinSocket	
{
   private:
      int iResult;
	  struct  sockaddr_in	Address;	//Structure to connect a socket to the host
   public:
	  int iPort;
	  WinHost * pWinHost;
      WinSocket();
      ~WinSocket();
      int SendSocket(CString m_message);
	  int ReturnResult(void){return iResult;}
};
//Declaration of WinIRCSever class
class WinIRC : public WinSocket
{
   private:
	  char cChannelName[0xffff];
	  WORD wChannelLenth;
	  WORD wChatNumber;
	  BOOL bResult;
   public:
       WinIRC(CString m_InitIRC);
	   ~WinIRC();
	   char * SelectChannel;
	   BOOL RetResult(){return bResult;}
};

#endif // ICR_H
