﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;
using System.Threading;
namespace FindExportsCS
{
    public partial class FindExports : Form
    {
        const UInt32 DONT_RESOLVE_DLL_REFERENCES    =     0x00000001;
        const UInt32 LOAD_LIBRARY_AS_DATAFILE       =     0x00000002;
        const UInt32 LOAD_WITH_ALTERED_SEARCH_PATH  =     0x00000008;
        const UInt32 LOAD_IGNORE_CODE_AUTHZ_LEVEL   =     0x00000010;
        const UInt32 LOAD_LIBRARY_AS_IMAGE_RESOURCE =     0x00000020;
        const UInt32 LOAD_LIBRARY_AS_DATAFILE_EXCLUSIVE = 0x00000040;
        const UInt32 LOAD_LIBRARY_REQUIRE_SIGNED_TARGET = 0x00000080;
        [DllImport("kernel32", SetLastError = true, CharSet = CharSet.Unicode)]
        static extern IntPtr LoadLibraryExW(string lpFileName, IntPtr hReservedNull, UInt32 dwFlags);
        [DllImport("kernel32", SetLastError = true, CharSet = CharSet.Unicode)]
        static extern IntPtr GetModuleHandleW(string lpFileName);
        [DllImport("kernel32",  SetLastError = true)]
        static extern bool FreeLibrary(IntPtr libraryHandle);
        [DllImport("kernel32", SetLastError = true, CharSet = CharSet.Unicode)]
        static extern IntPtr GetProcAddress(IntPtr moduleHandle, byte[] functionName);
        [DllImport("kernel32", SetLastError = true, CharSet = CharSet.Unicode)]
        static extern IntPtr GetProcAddress(IntPtr moduleHandle, int ii);
        private ListViewColumnSorter lvwColumnSorter;
        delegate void SetWindowTitleDelegate(string windowsTitle);
        delegate void SetListViewDataDelegate(ListViewItem lvi);
        delegate void ClearListViewDataDelegate();
        public FindExports()
        {
            InitializeComponent();
            lvwColumnSorter = new ListViewColumnSorter();
            this.listViewExports.ListViewItemSorter = lvwColumnSorter;

        }

        private void buttonOpen_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Title = "DLL file";
            openFileDialog.Filter = "DLL Files (.dll)|*.dll|All Files (*.*)|*.*";
            openFileDialog.FilterIndex = 1;
            if (DialogResult.OK == openFileDialog.ShowDialog())
            {
                string fileName = openFileDialog.FileName;

                Thread t = new Thread(new ParameterizedThreadStart(exportSearchThread));
                t.Start(fileName);

            }
        }

        private void listViewExports_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            // Determine if clicked column is already the column that is being sorted.
            if (e.Column == lvwColumnSorter.SortColumn)
            {
                // Reverse the current sort direction for this column.
                if (lvwColumnSorter.Order == SortOrder.Ascending)
                {
                    lvwColumnSorter.Order = SortOrder.Descending;
                }
                else
                {
                    lvwColumnSorter.Order = SortOrder.Ascending;
                }
            }
            else
            {
                // Set the column number that is to be sorted; default to ascending.
                lvwColumnSorter.SortColumn = e.Column;
                lvwColumnSorter.Order = SortOrder.Ascending;
            }

            // Perform the sort with these new sort options.
            this.listViewExports.Sort();
        }
        void exportSearchThread(object objfileName)
        {
            string fileName = objfileName.ToString();
            int nPos = fileName.LastIndexOf('\\');
            string safeFileName = fileName;
            if (nPos != 0)
            {
                safeFileName = fileName.Substring(nPos + 1);
            }
            IntPtr libraryHandle = IntPtr.Zero;
            IntPtr moduleHandle = GetModuleHandleW(fileName);
            if (moduleHandle == IntPtr.Zero)
            {
                libraryHandle = LoadLibraryExW(fileName, IntPtr.Zero, DONT_RESOLVE_DLL_REFERENCES);
                if (libraryHandle != IntPtr.Zero)
                {
                    moduleHandle = libraryHandle;
                }
            }
            if (moduleHandle != IntPtr.Zero)
            {
                byte[] ordinals = { 0, 0 };
                Dictionary<IntPtr, FunctionOrdAndName> funcDict = new Dictionary<IntPtr, FunctionOrdAndName>();
                for (int ii = 0; ii < 0x10000; ii++)
                {
                    IntPtr intPtrAddress = GetProcAddress(moduleHandle, ii);
                    if (intPtrAddress != IntPtr.Zero)
                    {
                        FunctionOrdAndName funcOrdAndName = new FunctionOrdAndName();
                        funcOrdAndName.ord = (uint)ii;
                        funcOrdAndName.funcName = "";
                        funcDict[intPtrAddress] = funcOrdAndName;
                    }
                }
                if (funcDict.Count > 0)
                {
                    byte[] buffer = null;
                    using (FileStream fs = new FileStream(fileName, FileMode.Open, FileAccess.Read))
                    {
                        buffer = new byte[fs.Length];
                        fs.Read(buffer, 0, (int)fs.Length);
                    }
                    uint nPosition = 0;
                    byte[] asciiFileName = System.Text.Encoding.ASCII.GetBytes(safeFileName);
                    for (int ii = 0; ii < asciiFileName.Length; ii++)
                    {
                        asciiFileName[ii] &= 0xdf;
                    }
                    if ((buffer != null) && (buffer.Length > safeFileName.Length))
                    {
                        for (int jj = safeFileName.Length; jj < buffer.Length; jj++)
                        {
                            if (buffer[jj] > 0x7f)
                                continue;
                            if ((buffer[jj] > 0) && (buffer[jj] < 0x21))
                                continue;
                            bool bNameFound = true;
                            int ll = jj - safeFileName.Length;
                            foreach (byte bt in asciiFileName)
                            {
                                byte bt1 = buffer[ll];
                                bt1 &= 0xdf;
                                if (bt != bt1)
                                {
                                    bNameFound = false;
                                    break;
                                }
                                ll++;
                            }
                            if (bNameFound)
                            {
                                if ((buffer[ll] == 0) && (buffer[ll + 1] > 0x21) && (buffer[ll + 1] < 0x7f))
                                    nPosition = (uint)ll;
                                else
                                    bNameFound = false;
                            }
                            if (bNameFound)
                                break;
                        }
                    }
                    if (nPosition > 0)
                    {
                        while (nPosition < buffer.Length)
                        {
                            nPosition++;
                            uint nPosition1 = nPosition;
                            for (int kl = (int)nPosition; kl < buffer.Length; kl++)
                            {
                                if (buffer[kl] == 0)
                                {
                                    nPosition1 = (uint)kl;
                                    break;
                                }
                            }
                            if (nPosition1 > nPosition)
                            {
                                byte[] buffer1 = new byte[nPosition1 - nPosition];
                                Array.Copy(buffer, nPosition, buffer1, 0, nPosition1 - nPosition);
                                IntPtr intPtrAddress = GetProcAddress(moduleHandle, buffer1);
                                if (intPtrAddress != IntPtr.Zero)
                                {
                                    string strFunction = Encoding.ASCII.GetString(buffer1);
                                    funcDict[intPtrAddress].funcName = strFunction;
                                }
                                nPosition = nPosition1;
                            }
                            else
                                break;
                        }
                        SetWindowTitleThread(fileName);
                        ClearListViewDataThread();
                        foreach (KeyValuePair<IntPtr, FunctionOrdAndName> kvp in funcDict)
                        {
                            ListViewItem lvi = new ListViewItem(String.Format("{0}", kvp.Value.ord));
                            lvi.SubItems.Add(kvp.Value.funcName);
                            lvi.SubItems.Add(String.Format("0x{0:x08}", (uint)kvp.Key));
                            SetListViewDataThread(lvi);
                        }
                    }
                    else
                    {
                        MessageBox.Show(String.Format("No export found in {0}", fileName));
                    }
                }
                else
                {
                    MessageBox.Show(String.Format("No export found in {0}", fileName));
                }
            }
            if (libraryHandle != IntPtr.Zero)
            {
                FreeLibrary(libraryHandle);
            }
 
        }
        private void SetWindowTitleThread(string fileName)
        {
            if (this.InvokeRequired)
            {
                SetWindowTitleDelegate x = new SetWindowTitleDelegate(SetWindowTitle);
                this.Invoke(x, new object[] { fileName });
            }
            else
            {
                SetWindowTitle(fileName);
            }
        }
        private void SetWindowTitle(string fileName)
        {
            this.Text = "List of export functions - " + fileName;
        }
        private void SetListViewDataThread(ListViewItem lvi)
        {
            if (this.InvokeRequired)
            {
                SetListViewDataDelegate x = new SetListViewDataDelegate(SetListViewData);
                this.Invoke(x, new object[] { lvi });
            }
            else
            {
                SetListViewData(lvi);
            }
        }
        private void SetListViewData(ListViewItem lvi)
        {
            listViewExports.Items.Add(lvi); 
        }
        private void ClearListViewDataThread()
        {
            if (this.InvokeRequired)
            {
                ClearListViewDataDelegate x = new ClearListViewDataDelegate(ClearListViewData);
                this.Invoke(x);
            }
            else
            {
                ClearListViewData();
            }
        }
        private void ClearListViewData()
        {
            listViewExports.Items.Clear();
        }
    }
    public class FunctionOrdAndName
    {
        public uint ord;
        public string funcName;
    }
 }
