
// FindExportsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FindExports.h"
#include "FindExportsDlg.h"
#include "afxdialogex.h"
#include <map>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
using namespace std;
typedef struct _FUNCTION
{
	int nOrdinal;
	CString csFunctionName;
} FUNCTION;
typedef map<FARPROC, FUNCTION> EXPORTMAP;
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CFindExportsDlg dialog




CFindExportsDlg::CFindExportsDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CFindExportsDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bMakeResizing = FALSE;
	m_nCX = 0;
    m_nCY = 0;
}

void CFindExportsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CFindExportsDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_LOAD_DLL, &CFindExportsDlg::OnBnClickedLoadDll)
END_MESSAGE_MAP()


// CFindExportsDlg message handlers

BOOL CFindExportsDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	GetWindowText(m_csDialogTitle);
	CListCtrl * pListCtrl = (CListCtrl*)GetDlgItem(IDC_LIST_EXPORTS);
	RECT rect;
    pListCtrl->GetClientRect(&rect);
    pListCtrl->InsertColumn(0, "Ordinal", LVCFMT_LEFT, rect.right/5 );
	pListCtrl->InsertColumn(1, "Function Name", LVCFMT_LEFT, (rect.right/5)*3 );
	pListCtrl->InsertColumn(2, "Address", LVCFMT_LEFT, rect.right/5 );
	pListCtrl->SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_bMakeResizing = TRUE;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFindExportsDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFindExportsDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFindExportsDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CFindExportsDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialogEx::OnSize(nType, cx, cy);
	WINDOWPLACEMENT lpwndplReport; 
	WINDOWPLACEMENT lpwndplButton; 
	if(m_bMakeResizing)
	{
	   CWnd * pWndReport = GetDlgItem(IDC_LIST_EXPORTS);
	   CWnd * pWndButton = GetDlgItem(IDC_LOAD_DLL);
	   pWndReport->GetWindowPlacement(&lpwndplReport);
       pWndButton->GetWindowPlacement(&lpwndplButton);
	   if(m_nCX!=cx)
	   {

	   }
	   if(m_nCY!=cy)
	   {
		  lpwndplReport.rcNormalPosition.bottom = 
              lpwndplReport.rcNormalPosition.bottom + (cy - m_nCY);
          lpwndplReport.showCmd = SW_SHOWNORMAL;
          pWndReport->SetWindowPlacement(&lpwndplReport);
		  lpwndplButton.rcNormalPosition.bottom = 
              lpwndplButton.rcNormalPosition.bottom + (cy - m_nCY);
		  lpwndplButton.rcNormalPosition.top= 
              lpwndplButton.rcNormalPosition.top + (cy - m_nCY);
          lpwndplButton.showCmd = SW_SHOWNORMAL;
          pWndButton->SetWindowPlacement(&lpwndplButton);
	   }
	   if(m_nCX!=cx)
	   {
		  lpwndplReport.rcNormalPosition.right = 
              lpwndplReport.rcNormalPosition.right + (cx - m_nCX);
          lpwndplReport.showCmd = SW_SHOWNORMAL;
          pWndReport->SetWindowPlacement(&lpwndplReport);
		  lpwndplButton.rcNormalPosition.right = 
              lpwndplButton.rcNormalPosition.right + (cx - m_nCX);
		  lpwndplButton.rcNormalPosition.left= 
              lpwndplButton.rcNormalPosition.left + (cx - m_nCX);
          lpwndplButton.showCmd = SW_SHOWNORMAL;
          pWndButton->SetWindowPlacement(&lpwndplButton);
	   }
	    ::InvalidateRect(m_hWnd,NULL,TRUE);
	}
	m_nCX = cx;
    m_nCY = cy;
}


void CFindExportsDlg::OnBnClickedLoadDll()
{
	CListCtrl * pListCtrl = (CListCtrl*)GetDlgItem(IDC_LIST_EXPORTS);
	HINSTANCE handleDLLLoad  = NULL; 
	EXPORTMAP exportMap;
	EXPORTMAP::iterator  exportMapIt;
	CFileDialog fileDialog(TRUE, _T("dll"), NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
         _T("DLL Files (*.dll)|*.dll|All Files (*.*)|*.*||"), NULL );
    fileDialog.m_ofn.lpstrTitle = _T("Add Additional DLL");
    if(fileDialog.DoModal() == IDOK)
    {
		CString csFileName = fileDialog.GetPathName();
		CString csModuleName = csFileName;
		TCHAR tcharBackSlash = '\\';
		int nPos = csFileName.ReverseFind(tcharBackSlash);
		if(nPos!=-1)
			csModuleName = csFileName.Right(csFileName.GetLength() - nPos - 1);
		HMODULE hModule = GetModuleHandle(csFileName);
		if(hModule==NULL)
		{
             handleDLLLoad  = LoadLibraryEx(csFileName,NULL, DONT_RESOLVE_DLL_REFERENCES);
			 if(handleDLLLoad)
				 hModule = handleDLLLoad;
		}
		if(hModule)
		{
			for(int nIndex = 0; nIndex <0xffff; nIndex++)
			{
				FARPROC pFProc = GetProcAddress(hModule, (LPCSTR)nIndex);
				if(pFProc != NULL)
				{
					FUNCTION function;
					function.nOrdinal = nIndex;
					function.csFunctionName = "";
					exportMap[pFProc] = function;
				}
			}
			if(exportMap.size()>0)
			{
				CString csWindowTitle;
				csWindowTitle = m_csDialogTitle;
				csWindowTitle += ", ";
				csWindowTitle += csFileName;
				SetWindowText((LPCTSTR)csWindowTitle);
				CFile dllFile = CFile(csFileName, CFile::modeRead | CFile::typeBinary);
				ULONGLONG fSize = dllFile.GetLength();
				BYTE * fileContents = new BYTE[fSize];
				dllFile.Read(fileContents, fSize);
				nPos = findstring(fileContents, (LPCTSTR)csModuleName, fSize);
				LPCSTR lpStrFunction = NULL;
				if(nPos!=0)
				{
                    nPos += strlen(csModuleName);
                    while(nPos<fSize)
                    {
						while((nPos<fSize) && (fileContents[nPos]==0))
						{
							nPos++;
						}
						LPCSTR lpStrFunction = (LPCSTR)&fileContents[nPos];
						FARPROC procAddress = GetProcAddress(hModule, (LPCSTR)lpStrFunction);
						if(procAddress!=NULL)
						{
							exportMap[procAddress].csFunctionName =  lpStrFunction;
						}
       					nPos += strlen(lpStrFunction);
                    }
				}
				dllFile.Close();
				if(fileContents!=NULL)
					delete[] fileContents;
				int nIndex = 0;
				char szBuffer[32];
				pListCtrl->DeleteAllItems();
				FUNCTION * pFunc;
				for(exportMapIt  = exportMap.begin(); exportMapIt != exportMap.end(); exportMapIt++) 
				{
					pFunc = &exportMapIt->second;
					sprintf(szBuffer,"%d",pFunc->nOrdinal);
					pListCtrl->InsertItem(nIndex, szBuffer);
					pListCtrl->SetItemText(nIndex,1,pFunc->csFunctionName);
					sprintf(szBuffer,"0x%08X",exportMapIt->first);
					pListCtrl->SetItemText(nIndex,2,szBuffer);
					nIndex++;
				}

			}
			if(handleDLLLoad)
			    FreeLibrary(handleDLLLoad);
		} else
		{
            CString csMsg = fileDialog.GetPathName() + " cannot be loaded!";
			MessageBox(csMsg, _T("Error"));
		}
    }
}
int CFindExportsDlg::findstring(BYTE * pbyFileContents, LPCTSTR szStringName, int nBytesRead, int nPos)
{
   int nPosFind = 0;
   int nIndex, nIndex1 = 0;
   BOOL bFound = FALSE;

   int nLength = strlen(szStringName);
   for(nIndex = nPos+1; nIndex<nBytesRead; nIndex++)
   {
      if(((pbyFileContents[nIndex-1]<0x20) || bFound) &&
         (pbyFileContents[nIndex] & 0xdf)==(szStringName[nIndex1] & 0xdf))
      {
         if(!bFound) nPosFind = nIndex;
         bFound = TRUE;
         nIndex1++;
      } else {
         bFound = FALSE;
         nIndex1 = 0;
      }
      if(nIndex && (nIndex1 == nLength) &&
         (strlen((LPCSTR)&pbyFileContents[nPosFind]) == nLength)) 
      {
         break;
      } 
   }
   if(nIndex1 != nLength)
   {
      nPosFind = 0;
   }
   return nPosFind;
}
