﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Diagnostics;
using System.Runtime.InteropServices;
namespace DebuggerSharp64
{
    class Program
    {
        static bool bContinueDebugging = true;
        struct ModuleInfo
        {
            public string fileName;
            public IntPtr baseAddress;
        }
        static List<ModuleInfo> moduleInfoList = new List<ModuleInfo>();
        static void Main(string[] args)
        {
            int nPid;
            if(args.Length==0)
            {
                Console.WriteLine("Please specify PID or Application to debug");
                    return;
            }
            try
            {
                nPid = Convert.ToInt32(args[0]);
            }
            catch(Exception ex)
            {
                Console.WriteLine("Not Valid pid parameter. Exception: " + ex.Message);
                return;
            }
            Thread t = new Thread(new ParameterizedThreadStart(DebuggerThread));

            t.Start(nPid);
            Console.ReadKey();
            bContinueDebugging = false;

        }
        static void DebuggerThread(object parameter)
        {
            uint nPid = Convert.ToUInt32(parameter);
            if (!PInvokes.DebugActiveProcess(nPid))
            {
                Console.WriteLine("Cannot debug the process with PID: {0}. Last Error 0x{1:x}", parameter.ToString(), (int)PInvokes.GetLastError());
            } 
            else
            {
                while (bContinueDebugging)
                {
                    IntPtr debugEventPtr = Marshal.AllocHGlobal(188);
                    bool bb = PInvokes.WaitForDebugEvent(debugEventPtr, 1000);
                    UInt32 dwContinueDebugEvent = PInvokes.DBG_CONTINUE;
                    if (bb)
                    {
                        PInvokes.DEBUG_EVENT DebugEvent = (PInvokes.DEBUG_EVENT)Marshal.PtrToStructure(debugEventPtr, typeof(PInvokes.DEBUG_EVENT));
                        IntPtr debugInfoPtr = GetIntPtrFromByteArray(DebugEvent.u);
                        switch(DebugEvent.dwDebugEventCode)
                        {
                            case PInvokes.CREATE_PROCESS_DEBUG_EVENT:
                                Console.WriteLine("CREATE_PROCESS_DEBUG_EVENT");
                                PInvokes.CREATE_PROCESS_DEBUG_INFO CreateProcessDebugInfo = (PInvokes.CREATE_PROCESS_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.CREATE_PROCESS_DEBUG_INFO));
                                break;
                            case PInvokes.CREATE_THREAD_DEBUG_EVENT:
                                Console.WriteLine("CREATE_THREAD_DEBUG_EVENT");
                  /*              PInvokes.CREATE_THREAD_DEBUG_INFO CreateThreadDebugInfo;
                                CreateThreadDebugInfo.hThread = (IntPtr)BitConverter.ToUInt64(DebugEvent.u, 0);
                                CreateThreadDebugInfo.lpThreadLocalBase = (IntPtr)BitConverter.ToUInt64(DebugEvent.u, 8);
                                CreateThreadDebugInfo.lpStartAddress = (PInvokes.PTHREAD_START_ROUTINE)Marshal.GetDelegateForFunctionPointer((IntPtr)BitConverter.ToUInt64(DebugEvent.u, 8), typeof(PInvokes.PTHREAD_START_ROUTINE));
 //                               CreateThreadDebugInfo.lpStartAddress = (PInvokes.PTHREAD_START_ROUTINE)BitConverter.ToUInt64(DebugEvent.u, 16);*/
                                break;
                            case PInvokes.EXCEPTION_DEBUG_EVENT:
                                PInvokes.EXCEPTION_DEBUG_INFO ExceptionDebugInfo = (PInvokes.EXCEPTION_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.EXCEPTION_DEBUG_INFO));
                                string exceptionDebugStr = String.Format("EXCEPTION_DEBUG_EVENT: Exception Address: 0x{0:x}, Exception code: 0x{1:x}",
                                    (ulong)ExceptionDebugInfo.ExceptionRecord.ExceptionAddress, ExceptionDebugInfo.ExceptionRecord.ExceptionCode);
                                Console.WriteLine(exceptionDebugStr);
                                switch (ExceptionDebugInfo.ExceptionRecord.ExceptionCode)
                                {
                                    case PInvokes.EXCEPTION_ACCESS_VIOLATION:
                                        Console.WriteLine("EXCEPTION_ACCESS_VIOLATION");
                                        break;

                                    case PInvokes.EXCEPTION_BREAKPOINT:
                                        Console.WriteLine("EXCEPTION_BREAKPOINT");
                                        break;

                                    case PInvokes.EXCEPTION_DATATYPE_MISALIGNMENT:
                                        Console.WriteLine("EXCEPTION_DATATYPE_MISALIGNMENT");
                                        break;

                                    case PInvokes.EXCEPTION_SINGLE_STEP:
                                        Console.WriteLine("EXCEPTION_SINGLE_STEP");
                                        break;

                                    case PInvokes.DBG_CONTROL_C:
                                        Console.WriteLine("DBG_CONTROL_C");
                                        break;

                                    default:
                                        Console.WriteLine("Handle other exceptions.");
                                        break;
                                }
                                break;
                            case PInvokes.EXIT_PROCESS_DEBUG_EVENT:
                                Console.WriteLine("CREATE_PROCESS_DEBUG_EVENT");
                                PInvokes.EXIT_PROCESS_DEBUG_INFO ExitProcessDebugInfo = (PInvokes.EXIT_PROCESS_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.EXIT_PROCESS_DEBUG_INFO));
                                bContinueDebugging = false;
                                break;
                            case PInvokes.EXIT_THREAD_DEBUG_EVENT:
                                Console.WriteLine("EXIT_THREAD_DEBUG_EVENT");
                                PInvokes.EXIT_THREAD_DEBUG_INFO ExitThreadDebugInfo = (PInvokes.EXIT_THREAD_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.EXIT_THREAD_DEBUG_INFO));
                                break;
                            case PInvokes.LOAD_DLL_DEBUG_EVENT:
                                PInvokes.LOAD_DLL_DEBUG_INFO LoadDLLDebugInfo = (PInvokes.LOAD_DLL_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.LOAD_DLL_DEBUG_INFO));
                                Console.WriteLine("LOAD_DLL_DEBUG_EVENT: Dll name: " + FindModule((int)nPid, LoadDLLDebugInfo));
                                break;
                            case PInvokes.OUTPUT_DEBUG_STRING_EVENT:
                                Console.WriteLine("OUTPUT_DEBUG_STRING_EVENT");
                                PInvokes.OUTPUT_DEBUG_STRING_INFO OutputDebugStringInfo = (PInvokes.OUTPUT_DEBUG_STRING_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.OUTPUT_DEBUG_STRING_INFO));
                                break;
                            case PInvokes.RIP_EVENT:
                                Console.WriteLine("RIP_EVENT");
                                PInvokes.RIP_INFO RipInfo = (PInvokes.RIP_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.RIP_INFO));
                                break;
                            case PInvokes.UNLOAD_DLL_DEBUG_EVENT:
                                PInvokes.UNLOAD_DLL_DEBUG_INFO UnloadDebugInfo = (PInvokes.UNLOAD_DLL_DEBUG_INFO)Marshal.PtrToStructure(debugInfoPtr, typeof(PInvokes.UNLOAD_DLL_DEBUG_INFO));
                                Console.WriteLine("UNLOAD_DLL_DEBUG_EVENT: Dll name: " + FindUnloadModule((int)nPid, UnloadDebugInfo));
                                break;
                        }
                        // Resume executing the thread that reported the debugging event. 
                        bool bb1 = PInvokes.ContinueDebugEvent((uint)DebugEvent.dwProcessId,
                                    (uint)DebugEvent.dwThreadId,
                                    dwContinueDebugEvent);
                    }
                    if (debugEventPtr != null)
                        Marshal.FreeHGlobal(debugEventPtr);
                }
                if (!PInvokes.DebugActiveProcessStop(nPid))
                {
                    Console.WriteLine("DebugActiveProcessStop failed");
                }
            }
        }
        private static IntPtr GetIntPtrFromByteArray(byte[] byteArray)
        {
            GCHandle pinnedArray = GCHandle.Alloc(byteArray, GCHandleType.Pinned);
            IntPtr intPtr = pinnedArray.AddrOfPinnedObject();
            pinnedArray.Free();
            return intPtr;
        }
        private static string FindUnloadModule(int nPid, PInvokes.UNLOAD_DLL_DEBUG_INFO UnloadDebugInfo)
        {
            string moduleName = "";
            int nIndex = 0;
            foreach(ModuleInfo moduleInfo in moduleInfoList)
            {
                if(moduleInfo.baseAddress == UnloadDebugInfo.lpBaseOfDll)
                {
                    moduleName = moduleInfo.fileName;
                    break;
                }
                nIndex++;
            }
            moduleInfoList.RemoveAt(nIndex);
            return moduleName;
        }

        private static string FindModule(int nPid, PInvokes.LOAD_DLL_DEBUG_INFO LoadDLLDebugInfo)
        {
            string moduleName = "";
            Process process = Process.GetProcessById(nPid);
            foreach (ProcessModule module in process.Modules)
            {
                if (module.BaseAddress == LoadDLLDebugInfo.lpBaseOfDll)
                {
                    moduleName = module.FileName;
                    ModuleInfo moduleInfo = new ModuleInfo();
                    moduleInfo.fileName = module.FileName;
                    moduleInfo.baseAddress = module.BaseAddress;
                    moduleInfoList.Add(moduleInfo);
                    break;
                }
            }
            return moduleName;
        }
    }
}
