using System;
using System.IO;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Security.Cryptography.X509Certificates;
//using System.ComponentModel;
//using System.Collections;
//using System.Diagnostics;
//using System.Text;
//using System.Security;
//http://www.jensign.com/KeyPal/source/KeyPal.txt
public class Win32 
{
   const uint PKCS_7_ASN_ENCODING	= 0x00010000;
   const uint X509_ASN_ENCODING	= 0x00000001;
   public const uint CERT_STORE_SAVE_AS_PKCS7  = 2;
   public const uint CERT_STORE_ADD_ALWAYS = 4;
   public const uint CERT_STORE_SAVE_TO_FILENAME_W = 4;
   public const uint ENCODING_TYPE		= PKCS_7_ASN_ENCODING | X509_ASN_ENCODING ;
   public const uint CERT_FIND_ANY  		= 0x00000000;
   public const uint CERT_NAME_SIMPLE_DISPLAY_TYPE =  4;
   public const uint CERT_STORE_PROV_MEMORY = 2;
   [DllImport("crypt32.dll")]
   public static extern IntPtr CertOpenSystemStore(IntPtr hCryptProv, string storename);
   [DllImport("crypt32.dll")]
   public static extern IntPtr CertOpenStore(uint lpszStoreProvider,  
                        uint dwMsgAndCertEncodingType,
                        IntPtr hCryptProv,
                        uint dwFlags,
                        IntPtr pvPara);
   [DllImport("crypt32.dll")]
   public static extern bool CertSaveStore(
      IntPtr hCertStore, uint dwMsgAndCertEncodingType, 
      uint dwSaveAs, uint dwSaveTo, 
      IntPtr pvSaveToPara, uint dwFlags);
   [DllImport("crypt32.dll")]
   public static extern bool CertAddCertificateLinkToStore(IntPtr hCertStore,
      IntPtr pCertCntxt, uint dwAddDisposition, IntPtr ppStoreContext);
   [DllImport("crypt32.dll")]
   public static extern bool CertCloseStore(IntPtr hCertStore, uint dwFlags) ;
   [DllImport("crypt32.dll", SetLastError=true)]
   public static extern IntPtr CertFindCertificateInStore(
      IntPtr hCertStore,
      uint dwCertEncodingType,
      uint dwFindFlags,
      uint dwFindType,
      IntPtr pvFindPara,
      IntPtr pPrevCertCntxt) ;
   [DllImport("crypt32.dll")]
   public static extern uint CertGetNameString(
      IntPtr pCertCntxt,
      uint dwType,
      uint dwFlags,
      IntPtr pvTypePara,
      IntPtr NameString,
      uint cchNameString);

   [StructLayout(LayoutKind.Sequential)]
      public struct CERT_CONTEXT
   {
      public uint dwCertEncodingType;  
      //public byte[] pbCertEncoded; 
      public IntPtr pbCertEncoded;
      public int cbCertEncoded;  
      public IntPtr pCertInfo;  
      public IntPtr hCertStore;
   }
}
namespace CertExportSharp
{
   /// <summary>
   /// Summary description for Update.
   /// </summary>
   public class Update
   {
      string m_srtStorage;
      public void UpdateCertificateList(string srtStorage, System.Windows.Forms.ListBox listBoxCertificates)
      {
         IntPtr hSysStore  = IntPtr.Zero;
         IntPtr hCertCntxt = IntPtr.Zero;
         X509Certificate x509Certificate;
         IntPtr NameString = Marshal.AllocHGlobal(1024);
         hSysStore = Win32.CertOpenSystemStore(IntPtr.Zero, srtStorage);
         if(hSysStore!=IntPtr.Zero)
         {
            m_srtStorage = srtStorage;
            hCertCntxt=Win32.CertFindCertificateInStore(
               hSysStore,
               Win32.ENCODING_TYPE,
               0, 
               Win32.CERT_FIND_ANY,
               IntPtr.Zero ,
               IntPtr.Zero) ;
            while(hCertCntxt!=IntPtr.Zero)
            {
               uint uiResult = Win32.CertGetNameString(hCertCntxt, Win32.CERT_NAME_SIMPLE_DISPLAY_TYPE,
                  0,IntPtr.Zero,
                  NameString, 1024);
               string CertString = Marshal.PtrToStringAnsi(NameString);
               if(uiResult>1)
               {
                  CertString += ", S/N=0x";
                  x509Certificate = new X509Certificate(hCertCntxt);
                  CertString +=  x509Certificate.GetSerialNumberString();
                  listBoxCertificates.Items.Add(CertString);
               } 
               hCertCntxt=Win32.CertFindCertificateInStore(
                  hSysStore,
                  Win32.ENCODING_TYPE,
                  0, 
                  Win32.CERT_FIND_ANY,
                  IntPtr.Zero ,
                  hCertCntxt) ;
            } //while(hCertCntxt!=IntPtr.Zero)
            Win32.CertCloseStore(hSysStore,0);
         }
         Marshal.FreeHGlobal(NameString);
      }
      public bool SaveCertificate(string CertName, string FileName, int nFilterIndex)
      {
         bool bResult = false;            
         Win32.CERT_CONTEXT cntxt;
         //find certificate
         IntPtr hSysStore  = IntPtr.Zero;
         IntPtr hCertCntxt = IntPtr.Zero;
         X509Certificate x509Certificate;
         IntPtr NameString = Marshal.AllocHGlobal(1024);
         hSysStore = Win32.CertOpenSystemStore(IntPtr.Zero, m_srtStorage);
         cntxt.cbCertEncoded = 0;
         cntxt.pbCertEncoded = IntPtr.Zero;
         byte[] pbyRawData = null;
         int nIndex;
         int nLen;
         if(hSysStore!=IntPtr.Zero)
         {
            hCertCntxt=Win32.CertFindCertificateInStore(
               hSysStore,
               Win32.ENCODING_TYPE,
               0, 
               Win32.CERT_FIND_ANY,
               IntPtr.Zero ,
               IntPtr.Zero) ;
            while(hCertCntxt!=IntPtr.Zero)
            {
               cntxt = (Win32.CERT_CONTEXT)Marshal.PtrToStructure(hCertCntxt, typeof(Win32.CERT_CONTEXT));
               uint uiResult = Win32.CertGetNameString(hCertCntxt, Win32.CERT_NAME_SIMPLE_DISPLAY_TYPE,
                  0,IntPtr.Zero,
                  NameString, 1024);
               string CertString = Marshal.PtrToStringAnsi(NameString);
               if(uiResult>1)
               {
                  CertString += ", S/N=0x";
                  x509Certificate = new X509Certificate(hCertCntxt);
                  CertString +=  x509Certificate.GetSerialNumberString();
                  if(CertString == CertName)
                  {
                     bResult = true; 
                     pbyRawData = x509Certificate.GetRawCertData();
//                     byte[] pbyPublicKey = x509Certificate.GetPublicKey();
//                     string str = x509Certificate.GetKeyAlgorithm();
                     break;
                  }
               }
               hCertCntxt=Win32.CertFindCertificateInStore(
                  hSysStore,
                  Win32.ENCODING_TYPE,
                  0, 
                  Win32.CERT_FIND_ANY,
                  IntPtr.Zero ,
                  hCertCntxt) ;
            } //while(hCertCntxt!=IntPtr.Zero)
            if(pbyRawData != null)
            {
               //byte[] RawData = x509Certificate.GetRawCertData();
               switch(nFilterIndex)
               {
                  case 1:
                     try 
                     {
                        FileStream  fs = File.Create(FileName); 
                        BinaryWriter bw = new BinaryWriter(fs); 
                        bw.Write(pbyRawData); 

                        bw.Close(); 
                        fs.Close(); 
                     } 
                     catch(Exception ) 
                     {
                        MessageBox.Show("File "+FileName+" cannot be opened for saving",
                           "Error",MessageBoxButtons.OK);
                     }
                     break;
                  case 2:
                     //convert to Base64
                     string strBase64 = Convert.ToBase64String(pbyRawData);
                     nIndex = 0;
                     try 
                     {
                        StreamWriter streamwriter = new StreamWriter(FileName);
                        streamwriter.WriteLine("-----BEGIN CERTIFICATE-----");
                        do 
                        {
                                   
                           nLen = 64;
                           if((nIndex+64)>strBase64.Length)
                              nLen = strBase64.Length - nIndex;
                           streamwriter.WriteLine(strBase64.Substring(nIndex,nLen));
                           nIndex += 64;
                        } while(nIndex<strBase64.Length);								
                        streamwriter.WriteLine("-----END CERTIFICATE-----");
                        streamwriter.Close();
                     }
                     catch(Exception ) 
                     {
                        MessageBox.Show("File "+FileName+" cannot be opened for saving",
                           "Error",MessageBoxButtons.OK);
                     }
                     break;
                  case 3:
                     //PKCS #7
                     IntPtr hSysStoreTmp = Win32.CertOpenStore(Win32.CERT_STORE_PROV_MEMORY,
                        Win32.ENCODING_TYPE, IntPtr.Zero, 0, IntPtr.Zero);
                     if(hSysStoreTmp != IntPtr.Zero)
                     {
                        if(Win32.CertAddCertificateLinkToStore(hSysStoreTmp,
                           hCertCntxt, Win32.CERT_STORE_ADD_ALWAYS, IntPtr.Zero))
                        {
                           if(Win32.CertSaveStore(hSysStoreTmp, Win32.ENCODING_TYPE, 
                              Win32.CERT_STORE_SAVE_AS_PKCS7, 
                              Win32.CERT_STORE_SAVE_TO_FILENAME_W, Marshal.StringToBSTR(FileName), 0) ==false)
                           {
                              MessageBox.Show("File "+FileName+" cannot be saved",
                                 "Error",MessageBoxButtons.OK);
                           }
                        } 
                        else 
                        {
                           MessageBox.Show(CertName+" Certificate cannot be added to the temporary storage",
                              "Error",MessageBoxButtons.OK);
                        }
                        Win32.CertCloseStore(hSysStoreTmp,0);
                     } 
                     else 
                     {
                        MessageBox.Show("Temporary Certificate Stoe in Memory cannot be opened",
                           "Error",MessageBoxButtons.OK);
                     }
                     break;
               }
            }
            Win32.CertCloseStore(hSysStore,0);
         }
         Marshal.FreeHGlobal(NameString);
         return bResult;
      }
   }
}
