using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Data;

namespace CertExportSharp
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
      public const int MF_BYPOSITION    =   0x00000400;
      public const int MF_SEPARATOR     =   0x00000800;
      public const int MF_STRING        =   0x00000000;
      public const int ID_APP_ABOUT     =   0xE140;
      public const int WM_SYSCOMMAND    =   0x0112;
      [DllImport("user32.dll")]
      private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);
      [DllImport("user32.dll")]
      private static extern bool AppendMenu(IntPtr hMenu, Int32 wFlags, Int32 wIDNewItem, string lpNewItem); 
      private int m_nHeight;
      private int m_nWidth; 
      private int m_nHeightListBox;
      private int m_nWidthListBox; 
      private System.Windows.Forms.Button ExportButton;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton radioButtonRoot;
		private System.Windows.Forms.RadioButton radioButtonCA;
		private System.Windows.Forms.RadioButton radioButtonSPC;
		private System.Windows.Forms.RadioButton radioButtonMy;
		private System.Windows.Forms.ListBox listBoxCertificates;
      private System.Windows.Forms.Form aboutDlg;
      private System.Windows.Forms.ContextMenu contextMenu; 
      private System.Windows.Forms.MenuItem menuSeparator; 
      private System.Windows.Forms.MenuItem menuCopyAll; 

      static public  Form1 thisForm;
		public Update update;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
         thisForm = this;
			update = new Update();
			radioButtonRoot.Checked = true;
         m_nHeight = Size.Height;
         m_nWidth = Size.Width; 
         m_nHeightListBox = listBoxCertificates.Size.Height;
         m_nWidthListBox = listBoxCertificates.Size.Width; 
         IntPtr sysMenuHandle = GetSystemMenu(Handle, false);
         AppendMenu(sysMenuHandle, MF_SEPARATOR, 0, string.Empty); 
         AppendMenu(sysMenuHandle, MF_STRING, ID_APP_ABOUT, "About CertExport..."); 
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
         System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
         this.ExportButton = new System.Windows.Forms.Button();
         this.groupBox1 = new System.Windows.Forms.GroupBox();
         this.radioButtonMy = new System.Windows.Forms.RadioButton();
         this.radioButtonSPC = new System.Windows.Forms.RadioButton();
         this.radioButtonCA = new System.Windows.Forms.RadioButton();
         this.radioButtonRoot = new System.Windows.Forms.RadioButton();
         this.listBoxCertificates = new System.Windows.Forms.ListBox();
         this.contextMenu = new System.Windows.Forms.ContextMenu();
         this.menuSeparator = new System.Windows.Forms.MenuItem();
         this.menuCopyAll = new System.Windows.Forms.MenuItem();
         this.groupBox1.SuspendLayout();
         this.SuspendLayout();
         // 
         // ExportButton
         // 
         this.ExportButton.Enabled = false;
         this.ExportButton.Location = new System.Drawing.Point(512, 8);
         this.ExportButton.Name = "ExportButton";
         this.ExportButton.TabIndex = 0;
         this.ExportButton.Text = "Export";
         this.ExportButton.Click += new System.EventHandler(this.ExportButton_Click);
         // 
         // groupBox1
         // 
         this.groupBox1.Controls.Add(this.radioButtonMy);
         this.groupBox1.Controls.Add(this.radioButtonSPC);
         this.groupBox1.Controls.Add(this.radioButtonCA);
         this.groupBox1.Controls.Add(this.radioButtonRoot);
         this.groupBox1.Location = new System.Drawing.Point(16, 32);
         this.groupBox1.Name = "groupBox1";
         this.groupBox1.Size = new System.Drawing.Size(568, 56);
         this.groupBox1.TabIndex = 1;
         this.groupBox1.TabStop = false;
         this.groupBox1.Text = "Storages";
         // 
         // radioButtonMy
         // 
         this.radioButtonMy.Location = new System.Drawing.Point(456, 24);
         this.radioButtonMy.Name = "radioButtonMy";
         this.radioButtonMy.TabIndex = 3;
         this.radioButtonMy.Text = "MY";
         this.radioButtonMy.CheckedChanged += new System.EventHandler(this.radioButtonMy_CheckedChanged);
         // 
         // radioButtonSPC
         // 
         this.radioButtonSPC.Location = new System.Drawing.Point(304, 24);
         this.radioButtonSPC.Name = "radioButtonSPC";
         this.radioButtonSPC.TabIndex = 2;
         this.radioButtonSPC.Text = "SPC";
         this.radioButtonSPC.CheckedChanged += new System.EventHandler(this.radioButtonSPC_CheckedChanged);
         // 
         // radioButtonCA
         // 
         this.radioButtonCA.Location = new System.Drawing.Point(152, 24);
         this.radioButtonCA.Name = "radioButtonCA";
         this.radioButtonCA.TabIndex = 1;
         this.radioButtonCA.Text = "CA";
         this.radioButtonCA.CheckedChanged += new System.EventHandler(this.radioButtonCA_CheckedChanged);
         // 
         // radioButtonRoot
         // 
         this.radioButtonRoot.Location = new System.Drawing.Point(8, 24);
         this.radioButtonRoot.Name = "radioButtonRoot";
         this.radioButtonRoot.Size = new System.Drawing.Size(96, 24);
         this.radioButtonRoot.TabIndex = 0;
         this.radioButtonRoot.Text = "Root";
         this.radioButtonRoot.CheckedChanged += new System.EventHandler(this.radioButtonRoot_CheckedChanged);
         // 
         // listBoxCertificates
         // 
         this.listBoxCertificates.ContextMenu = this.contextMenu;
         this.listBoxCertificates.Location = new System.Drawing.Point(8, 96);
         this.listBoxCertificates.Name = "listBoxCertificates";
         this.listBoxCertificates.Size = new System.Drawing.Size(576, 329);
         this.listBoxCertificates.Sorted = true;
         this.listBoxCertificates.TabIndex = 2;
         this.listBoxCertificates.SelectedIndexChanged += new System.EventHandler(this.listBoxCertificates_SelectedIndexChanged);
         // 
         // contextMenu
         // 
         this.contextMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
                                                                                    this.menuSeparator,
                                                                                    this.menuCopyAll});
         this.contextMenu.Popup += new System.EventHandler(this.contextMenu_Popup);
         // 
         // menuSeparator
         // 
         this.menuSeparator.Index = 0;
         this.menuSeparator.Text = "-";
         // 
         // menuCopyAll
         // 
         this.menuCopyAll.Index = 1;
         this.menuCopyAll.Text = "Copy All To Clipboard";
         this.menuCopyAll.Click += new System.EventHandler(this.menuCopyAll_Click);
         // 
         // Form1
         // 
         this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
         this.ClientSize = new System.Drawing.Size(600, 448);
         this.Controls.Add(this.listBoxCertificates);
         this.Controls.Add(this.groupBox1);
         this.Controls.Add(this.ExportButton);
         this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
         this.MaximizeBox = false;
         this.MinimizeBox = false;
         this.Name = "Form1";
         this.Text = "Certificate Export";
         this.Resize += new System.EventHandler(this.Form1_Resize);
         this.groupBox1.ResumeLayout(false);
         this.ResumeLayout(false);

      }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
         Application.Run(new Form1());
      }

		private void radioButtonRoot_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonRoot.Checked == true)
			{
				ExportButton.Enabled = false;
			    listBoxCertificates.Items.Clear();
				update.UpdateCertificateList("ROOT", listBoxCertificates);
			}
		}

		private void radioButtonCA_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonCA.Checked == true) 
			{
				ExportButton.Enabled = false;
				listBoxCertificates.Items.Clear();
				update.UpdateCertificateList("CA", listBoxCertificates);
			}
		}

		private void radioButtonSPC_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonSPC.Checked == true) 
			{
				ExportButton.Enabled = false;
				listBoxCertificates.Items.Clear();
				update.UpdateCertificateList("SPC", listBoxCertificates);
			}
		}

		private void radioButtonMy_CheckedChanged(object sender, System.EventArgs e)
		{
			if(radioButtonMy.Checked == true)
			{
				ExportButton.Enabled = false;
				listBoxCertificates.Items.Clear();
				update.UpdateCertificateList("MY", listBoxCertificates);
			}
		}

		private void listBoxCertificates_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		    int nItemIndex = listBoxCertificates.SelectedIndex;
			if(nItemIndex>=0)
				ExportButton.Enabled = true;
		}

		private void ExportButton_Click(object sender, System.EventArgs e)
		{
			string szExportTitle;
			int nItemIndex = listBoxCertificates.SelectedIndex;
			string szItemText = listBoxCertificates.Items[nItemIndex].ToString();
			System.Windows.Forms.DialogResult DialogRes;
			System.Windows.Forms.SaveFileDialog FileDialog = new SaveFileDialog();
			FileDialog.Filter = "DER Encoded Binary X.509 (*.cer)|*.cer|Base-64 encoded X.509 (*.cer)|*.cer|PKCS #7 Certificates (*.p7b)|*.p7b||";
			FileDialog.DefaultExt = "cer";
			szExportTitle = "Export ";
			szExportTitle += szItemText;
			FileDialog.Title = szExportTitle;
         FileDialog.FilterIndex = 3;
			DialogRes = FileDialog.ShowDialog();
			if(DialogRes == System.Windows.Forms.DialogResult.OK)
			{
				if(update.SaveCertificate(szItemText, FileDialog.FileName, FileDialog.FilterIndex) == false)
				{

				}
			}
		}

      private void Form1_Resize(object sender, System.EventArgs e)
      {
         int nHeight = this.Size.Height;
         int nWidth = this.Size.Width;
         listBoxCertificates.SetBounds(0,0, m_nWidthListBox + (nWidth - m_nWidth),
            m_nHeightListBox + (nHeight - m_nHeight), System.Windows.Forms.BoundsSpecified.Size);
      }
      protected override void WndProc ( ref Message msg )
      {
         if ( msg.Msg == WM_SYSCOMMAND )
         {
            switch ( msg.WParam.ToInt32() )
            {
               case ID_APP_ABOUT: 
                     aboutDlg = new AboutDlg();
                  aboutDlg.Show();
                  break;
            }
         }
         base.WndProc(ref msg);
      }

      private void menuCopyAll_Click(object sender, System.EventArgs e)
      {
         string strListBoxContents = "";      
         int nIndex;
         for(nIndex = 0; nIndex<listBoxCertificates.Items.Count; nIndex++)
         {
            strListBoxContents += listBoxCertificates.Items[nIndex].ToString();
            strListBoxContents += "\r\n";
         }
         Clipboard.SetDataObject(strListBoxContents,true);
      }

      private void contextMenu_Popup(object sender, System.EventArgs e)
      {
         bool bEnb = false;
         if(listBoxCertificates.Items.Count>0)
            bEnb = true;
         menuCopyAll.Enabled = bEnb;
      }
	}
}
